import abc

import numpy as np


class VariantSpace:
    def __init__(self, variant_config):
        self.variant_config = variant_config

    def sample(self):
        variant = {}
        for key, distribution in self.variant_config.items():
            variant[key] = distribution.sample()

        return variant


##################################################


class Distribution:
    def __init__(self, **kwargs):
        self.kwargs = kwargs

    @abc.abstractmethod
    def sample(self):
        pass


class Uniform(Distribution):
    def sample(self):
        return np.random.uniform(**self.kwargs)


class Normal(Distribution):
    def sample(self):
        return np.random.normal(**self.kwargs)


class Categorical(Distribution):
    def sample(self):
        return np.random.choice(**self.kwargs)
